#ifdef GL_ES
precision mediump float;

varying float specular;
varying float diffuse;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in float specular;
in float diffuse;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform sampler2D lightTex;
uniform vec4 inColor;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
    vec3 fColor = (texture2D(lightTex, vTexCoord.st).r * inColor.a) * inColor.rgb;
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
    vec3 fColor = (texture(lightTex, vTexCoord.st).r * inColor.a) * inColor.rgb;
#endif
	fragColor = vec4((tColor.rgb * diffuse) + vec3(specular * tColor.a) + fColor, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
